<?php

function getPassword($sock, $index)
{
   $cameras = ParamGet($sock, "video");
   $cameras = $cameras->video->input;
   $cameras = sort_nested_arrays($cameras, ["index" => "desc"]);
   $password = $cameras[$index]->cam_password;
   return $password;
}
function exportToServer($array, $atr, $sock, $index)
{
   if ($atr == "va_rec") {
      foreach ($array as $arr) {
         if ($arr["value"] == 0) {
            ParamUnset($sock, "video.input.[" . $index . "].$atr.[" . $arr["index"] . "]");
         } else {
            ParamSetInt($sock, "video.input.[" . $index . "].$atr.[" . $arr["index"] . "]", $arr["value"]);
         }
      }
   } else {
      foreach ($array as $arr) {
         ParamSetInt($sock, "video.input.[" . $index . "].$atr.[" . $arr["index"] . "]", $arr["value"]);
      }
   }
}
function checkArray($newArray, $oldArray)
{
   $arr = [];
   foreach ($oldArray as $oldObj) {
      foreach ($newArray as $obj) {
         if ($obj["index"] === $oldObj->index && $obj["value"] != $oldObj->value) {
            array_push($arr, $obj);
         }
      }
   }
   return $arr;
}
function getElement($arr, $index)
{
   foreach ($arr as $obj) {
      if ($obj->index == $index) {
         $element = $obj;
      }
   }
   return $element;
}
function checkSignal($stat, $index)
{
   $index += 1;
   $status = 0;
   foreach ($stat as $camera) {
      if ($camera->id == $index) {
         if ($camera->fps[0] != 0 || $camera->fps[1] != 0) {
            $status = 1;
            break;
         }
         break;
      }
   }
   return $status;
}
function getCodec($stat, $index)
{
   $codec = [0, 0];
   $index += 1;
   foreach ($stat as $camera) {
      if ($camera->id == $index) {
         $codec[0] = $camera->codec[0];
         $codec[1] = $camera->codec[1];
         break;
      }
   }
   return $codec;
}

function findChannel($arr, $index)
{
   $result = (object) [];
   foreach ($arr as $channel) {
      if (isset($channel->index) && $channel->index === $index) {
         $result = $channel;
         break;
      }
   }
   return $result;
}
function GetUserById($id, $arr)
{
   $user = null;
   $users = $arr->security->user ?? [];

   if (!count($users)) {
      return $user;
   }

   $key = array_search($id, array_column($users, "id"));

   return $key !== false ? $users[$key] : $user;
}
function getNeedProps($arr, $props)
{
   $result = [];
   foreach ($arr as $camera) {
      $cam = [];
      foreach ($props as $prop) {
         if (isset($camera->$prop)) {
            $cam += [$prop => $camera->$prop];
         }
      }
      array_push($result, $cam);
   }
   return $result;
}
function audioAccess($sock, $inputs)
{
   $arr = ParamGet($sock, "audio");

   if (isset($arr->audio->input)) {
      $arr = $arr->audio->input;
      $arr = sort_nested_arrays($arr, ["index" => "desc"]);
      return $arr;
   }

   $input = [];
   $arr->audio->input = $input;
   $arr = $arr->audio->input;
   for ($i = 0; $i < $inputs; $i++) {
      $audio_item = ["index" => $i, "enabled" => 0, ["play" => 1, "read" => 1]];
      $arr[$i] = $audio_item;
   }
   return $arr;
}
